//
//  SubForm05ViewController.m
//  iOS SDK Sample
//
//  Created by NEI アプリGr on 2013/07/05.
//  Copyright (c) 2013年 Nippon Primex Inc. All rights reserved.
//

#import "SubForm05ViewController.h"

@interface SubForm05ViewController ()

@end

@implementation SubForm05ViewController

@synthesize objLib = mObjLib;
@synthesize strPrtName = mStrPrtName;
@synthesize sclView = mSclView;

-(void) btnViewSetting : (UIButton *) btnObj
{
    NSString* osversion = [UIDevice currentDevice].systemVersion;
    NSArray* a = [osversion componentsSeparatedByString:@"."];
    
    if([(NSString*)[a objectAtIndex:0] intValue] >= 7)
    {
        btnObj.layer.borderColor = [UIColor blueColor].CGColor;
        btnObj.layer.borderWidth = 1.0f;
        btnObj.layer.cornerRadius = 7.5f;
        
        btnObj.backgroundColor = [UIColor colorWithRed:0.95 green:1.0 blue:1.0 alpha:1.0];
        [btnObj setTintColor:[UIColor blackColor]];
    }
}

-(void) setReturnCode :(int) nmsResult
{
    lblReturnCode.text = [NSString stringWithFormat:@"Return Code: %d", nmsResult];
    
    if(nmsResult != 0)
    {
        lblReturnCode.textColor = [UIColor redColor];
    }
    else
    {
        lblReturnCode.textColor = [UIColor blackColor];
    }
}

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        // Custom initialization
    }
    return self;
}

-(void) appClose
{
    [mObjLib NClosePrinters];
}

-(void) viewDidLayoutSubviews
{
    int nmsWidth    = 0;
    int nmsHeight    = btnBack.frame.origin.y + btnBack.frame.size.height + 200;
    
    [mSclView setContentSize: CGSizeMake(nmsWidth, nmsHeight)];
    [mSclView flashScrollIndicators];
}

- (void)viewDidLoad
{
    [super viewDidLoad];
	// Do any additional setup after loading the view.
    
    [self btnViewSetting:btnNBarcode];
    [self btnViewSetting:btnImageSelect];
    [self btnViewSetting:btnBcdSetting];
    [self btnViewSetting:btnSettingCheck];
    [self btnViewSetting:btnClear];
    [self btnViewSetting:btnBack];
    
    
    txtBcdFontname.delegate = self;
    txtBitmapWidth.delegate = self;
    txtBitmapHeight.delegate = self;
    txtX.delegate = self;
    txtY.delegate = self;
    txtWidth.delegate = self;
    txtHeight.delegate = self;
    txtData.delegate = self;
    
    txtSetFontnumber.delegate = self;
    txtSetBcdType.delegate = self;
    txtSetWidth.delegate = self;
    txtSetHeight.delegate = self;
    txtSetHRI.delegate = self;
    txtSetHexmode.delegate = self;
    txtSetRotate.delegate = self;
    txtSetStartBit.delegate = self;
    txtSetStopBit.delegate = self;
    txtSetFilename.delegate = self;    
    
    nmsImageCode = 0x00;
    
    dicImgFile = [NSDictionary dictionaryWithObjectsAndKeys:
                  @"barcode01.png",@"Barcode1",
                  @"barcode02.png",@"Barcode2",
                  @"barcode03.png",@"Barcode3",
                  @"barcode04.png",@"Barcode4",
                  @"barcode05.png",@"Barcode5",
                  @"barcode06.png",@"Barcode6",
                  @"barcode07.png",@"Barcode7",
                  @"barcode08.png",@"Barcode8",
                  @"barcode09.png",@"Barcode9",
                  @"barcode10.png",@"Barcode10",
                  nil];
    
    // App close setting(Enter backgroud)
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(appClose)
                                                 name:UIApplicationDidEnterBackgroundNotification object:nil];
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

-(BOOL)textFieldShouldReturn:(UITextField*) textField {
    [textField resignFirstResponder];
    return YES;
}

-(bool) NBarcodeInputCheck
{
    if(![self isDigit:[txtBitmapWidth text]])
    {
        UIAlertView* alert = [[UIAlertView alloc]
                              initWithTitle:@""
                              message:@"Bitmap width is invalid."
                              delegate:nil
                              cancelButtonTitle:@"OK"
                              otherButtonTitles:nil];
        
        [alert show];
        return false;
    }

    if(![self isDigit:[txtBitmapHeight text]])
    {
        UIAlertView* alert = [[UIAlertView alloc]
                              initWithTitle:@""
                              message:@"Bitmap height is invalid."
                              delegate:nil
                              cancelButtonTitle:@"OK"
                              otherButtonTitles:nil];
        
        [alert show];
        return false;
    }
    
    if(![self isDigit:[txtX text]])
    {
        UIAlertView* alert = [[UIAlertView alloc]
                              initWithTitle:@""
                              message:@"i_x is invalid."
                              delegate:nil
                              cancelButtonTitle:@"OK"
                              otherButtonTitles:nil];
        
        [alert show];
        return false;
    }
    
    if(![self isDigit:[txtY text]])
    {
        UIAlertView* alert = [[UIAlertView alloc]
                              initWithTitle:@""
                              message:@"i_y is invalid."
                              delegate:nil
                              cancelButtonTitle:@"OK"
                              otherButtonTitles:nil];
        
        [alert show];
        return false;
    }
    
    if(![self isDigit:[txtWidth text]])
    {
        UIAlertView* alert = [[UIAlertView alloc]
                              initWithTitle:@""
                              message:@"i_width is invalid."
                              delegate:nil
                              cancelButtonTitle:@"OK"
                              otherButtonTitles:nil];
        
        [alert show];
        return false;
    }
    
    if(![self isDigit:[txtHeight text]])
    {
        UIAlertView* alert = [[UIAlertView alloc]
                              initWithTitle:@""
                              message:@"i_height is invalid."
                              delegate:nil
                              cancelButtonTitle:@"OK"
                              otherButtonTitles:nil];
        
        [alert show];
        return false;
    }
    
    NSString* strData = [txtData text];
    if(strData == nil || [strData isEqualToString:@""])
    {
        return false;
    }
    
    return true;
}

- (IBAction)pushBtnNBarcode:(UIButton *)sender
{
    int nmsRet = 0;
  
    NSString* strBcdFont = [txtBcdFontname text];
    
    if(![self NBarcodeInputCheck])
    {
        return;
    }
    
    // UIImage create
    int bitmapWidth = [[txtBitmapWidth text] intValue];
    int bitmapHeight = [[txtBitmapHeight text] intValue];
    UIImage* objBitmap = [self imageWithColor:[UIColor yellowColor] :bitmapWidth :bitmapHeight];
    
    
    int nmsX = [[txtX text] intValue];
    int nmsY = [[txtY text] intValue];
    
    int nmsWidth  = [[txtWidth text] intValue];
    int nmsHeight = [[txtHeight text] intValue];
    
    char* datBuf = (char*)[[txtData text] UTF8String];
    int nmsDatLen = (int)[[txtData text] length];
    
    
    // comment:NPI NBarcode
    nmsRet = [mObjLib NBarcode: mStrPrtName : strBcdFont : objBitmap : nmsX : nmsY :nmsWidth :nmsHeight :datBuf :nmsDatLen];
    
    if(nmsRet != N_SUCCESS)
    {
        [self setReturnCode:nmsRet];
        return;
    }
    
    
    // Barcode image file print
    NSString* imgFileName;

    
    int nmsBarcodeType  = 0;
    int nmsBcdWidth     = 0;
    int nmsBcdHeight    = 0;
    int nmsHRI          = 0;
    int nmsHexMode      = 0;
    int nmsRotate       = 0;
    int nmsStartBit     = 0;
    int nmsStopBit      = 0;
    NSMutableString* strFileName = [NSMutableString string];
    
    // comment:NPI NBarcode1DGetData(get barcode image file path)
    nmsRet = [mObjLib NBarcode1DGetData : [txtBcdFontname text] : &nmsBarcodeType :&nmsBcdWidth :&nmsBcdHeight :&nmsHRI :&nmsHexMode :&nmsRotate :&nmsStartBit :&nmsStopBit :strFileName];
    if(nmsRet == N_SUCCESS)
    {
        imgFileName = strFileName;
    }
    
        
    NSArray* paths = NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES);
    

    NSString* stahomeDir = [paths objectAtIndex:0];
    NSString* i_file = [NSString stringWithFormat:@"%@/npi/image/%@", stahomeDir, imgFileName];
    
    // comment:NPI NImagePrintF(barcode image file print)
    nmsRet = [mObjLib NImagePrintF : mStrPrtName : i_file :nmsImageCode :nil];
    [self setReturnCode:nmsRet];
}

- (IBAction)pushBtnBack : (UIButton *)sender
{
    [self dismissViewControllerAnimated:YES completion:nil];
}

- (IBAction)pushBtnSelectImageType:(UIButton *)sender
{
    NSString* lblText = [lblImageType text];
    
    if([lblText isEqualToString:@"Raster line"])
    {
        lblImageType.text = @"Raster block";
        nmsImageCode = 0x01;
    }
    else if([lblText isEqualToString:@"Raster block"])
    {
        lblImageType.text = @"Raster gradation";
        lblImageType.adjustsFontSizeToFitWidth = YES;
        nmsImageCode = 0x02;
    }
    else if([lblText isEqualToString:@"Raster gradation"])
    {
        lblImageType.text = @"Bit image";
        nmsImageCode = 0x10;
    }
    else
    {
        lblImageType.text = @"Raster line";
        nmsImageCode = 0x00;
    }
}

- (IBAction)pushBtnNBarcode1DSetting:(UIButton *)sender
{
    // Barcode setting file edit
    //  1st argument: Font number (1-10)
    //  2nd argument: Barcode type (0-8)
    //  3rd argument: Width
    //  4th argument: Height
    //  5th argument: HRI (0-6)
    //  6th argument: Hex mode (0 or 1)
    //  7th argument: Rotate (0-3)
    //  8th argument: Start bit (0-3)
    //  9th argument: Stop bit (0-3)
    // 10th argument: File name
    
    int nmsRet = 0;
    
    if(![self barcodeSettingInputCheck])
    {
        return;
    }
    
    int nmsBcdType      = [[txtSetBcdType text]intValue];
    int nmsWidth        = [[txtSetWidth text]intValue];
    int nmsHeight       = [[txtSetHeight text]intValue];
    int nmsHRI          = [[txtSetHRI text]intValue];
    int nmsHexmode      = [[txtSetHexmode text]intValue];
    int nmsRotate       = [[txtSetRotate text]intValue];
    int nmsStartBit     = [[txtSetStartBit text]intValue];
    int nmsStopBit      = [[txtSetStopBit text]intValue];
    NSString* strFileName = [txtSetFilename text];
    
    
    // comment:NPI NBarcode1DSetting
    nmsRet = [mObjLib NBarcode1DSetting : [txtSetFontnumber text] : nmsBcdType : nmsWidth : nmsHeight : nmsHRI : nmsHexmode : nmsRotate : nmsStartBit : nmsStopBit : strFileName];
    
    [self setReturnCode:nmsRet];
}

-(BOOL) isDigit:(NSString*) inString
{
    if(inString == nil || [inString isEqualToString:@""])
    {
        return NO;
    }
    
    NSCharacterSet* digitCharSet = [NSCharacterSet characterSetWithCharactersInString:@"0123456789"];
    
    NSScanner* aScan = [NSScanner localizedScannerWithString:inString];
    [aScan setCharactersToBeSkipped:nil];
    
    [aScan scanCharactersFromSet:digitCharSet intoString:NULL];
    return [aScan isAtEnd];
}

-(bool) barcodeSettingInputCheck
{
    if(![self isDigit:[txtSetBcdType text]])
    {
        UIAlertView* alert = [[UIAlertView alloc]
                              initWithTitle:@""
                              message:@"Barcode type is invalid."
                              delegate:nil
                              cancelButtonTitle:@"OK"
                              otherButtonTitles:nil];
        
        [alert show];
        return false;
    }
    
    if(![self isDigit:[txtSetWidth text]])
    {
        UIAlertView* alert = [[UIAlertView alloc]
                              initWithTitle:@""
                              message:@"Width is invalid."
                              delegate:nil
                              cancelButtonTitle:@"OK"
                              otherButtonTitles:nil];
        
        [alert show];
        return false;
    }
    
    if(![self isDigit:[txtSetHeight text]])
    {
        UIAlertView* alert = [[UIAlertView alloc]
                              initWithTitle:@""
                              message:@"Height is invalid."
                              delegate:nil
                              cancelButtonTitle:@"OK"
                              otherButtonTitles:nil];
        
        [alert show];
        return false;
    }
    
    if(![self isDigit:[txtSetHRI text]])
    {
        UIAlertView* alert = [[UIAlertView alloc]
                              initWithTitle:@""
                              message:@"HRI is invalid."
                              delegate:nil
                              cancelButtonTitle:@"OK"
                              otherButtonTitles:nil];
        
        [alert show];
        return false;
    }
    
    if(![self isDigit:[txtSetHexmode text]])
    {
        UIAlertView* alert = [[UIAlertView alloc]
                              initWithTitle:@""
                              message:@"Hex mode is invalid."
                              delegate:nil
                              cancelButtonTitle:@"OK"
                              otherButtonTitles:nil];
        
        [alert show];
        return false;
    }
    
    if(![self isDigit:[txtSetRotate text]])
    {
        UIAlertView* alert = [[UIAlertView alloc]
                              initWithTitle:@""
                              message:@"Rotate is invalid."
                              delegate:nil
                              cancelButtonTitle:@"OK"
                              otherButtonTitles:nil];
        
        [alert show];
        return false;
    }
    
    if(![self isDigit:[txtSetStartBit text]])
    {
        UIAlertView* alert = [[UIAlertView alloc]
                              initWithTitle:@""
                              message:@"Start Bit is invalid."
                              delegate:nil
                              cancelButtonTitle:@"OK"
                              otherButtonTitles:nil];
        
        [alert show];
        return false;
    }

    if(![self isDigit:[txtSetStopBit text]])
    {
        UIAlertView* alert = [[UIAlertView alloc]
                              initWithTitle:@""
                              message:@"Stop Bit is invalid."
                              delegate:nil
                              cancelButtonTitle:@"OK"
                              otherButtonTitles:nil];
        
        [alert show];
        return false;
    }
    
    return true;
}

- (IBAction)pushBtnNBarcode1DGetData:(UIButton *)sender
{
    int nmsRet = 0;

    int nmsBarcodeType  = 0;
    int nmsBcdWidth     = 0;
    int nmsBcdHeight    = 0;
    int nmsHRI          = 0;
    int nmsHexMode      = 0;
    int nmsRotate       = 0;
    int nmsStartBit     = 0;
    int nmsStopBit      = 0;
    NSMutableString* strFileName = [NSMutableString string];
    
    // comment:NPI NBarcode1DGetData
    nmsRet = [mObjLib NBarcode1DGetData : [txtSetFontnumber text] :&nmsBarcodeType :&nmsBcdWidth :&nmsBcdHeight :&nmsHRI :&nmsHexMode :&nmsRotate :&nmsStartBit :&nmsStopBit :strFileName];
    if(nmsRet == N_SUCCESS)
    {        
        txtSetBcdType.text  = [[NSNumber numberWithInt:nmsBarcodeType] stringValue];
        txtSetWidth.text    = [[NSNumber numberWithInt:nmsBcdWidth] stringValue];
        txtSetHeight.text   = [[NSNumber numberWithInt:nmsBcdHeight] stringValue];
        txtSetHRI.text      = [[NSNumber numberWithInt:nmsHRI] stringValue];
        txtSetHexmode.text  = [[NSNumber numberWithInt:nmsHexMode] stringValue];
        txtSetRotate.text   = [[NSNumber numberWithInt:nmsRotate] stringValue];
        txtSetStartBit.text = [[NSNumber numberWithInt:nmsStartBit] stringValue];
        txtSetStopBit.text  = [[NSNumber numberWithInt:nmsStopBit] stringValue];
        txtSetFilename.text = strFileName;
    }

    [self setReturnCode:nmsRet];
}

- (IBAction)pushBtnInputClear:(UIButton *)sender
{
    txtSetFontnumber.text   = @"";
    txtSetBcdType.text      = @"";
    txtSetWidth.text        = @"";
    txtSetHeight.text       = @"";
    txtSetHRI.text          = @"";
    txtSetHexmode.text      = @"";
    txtSetRotate.text       = @"";
    txtSetStartBit.text     = @"";
    txtSetStopBit.text      = @"";
    txtSetFilename.text     = @"";
}


-(UIImage*) imageWithColor : (UIColor*) color : (int) nWidth : (int) nHeight
{
    CGRect rect = CGRectMake(0, 0, nWidth, nHeight);
    UIGraphicsBeginImageContext(rect.size);
    CGContextRef context = UIGraphicsGetCurrentContext();
        
    CGContextSetFillColorWithColor(context, [color CGColor]);
    CGContextFillRect(context, rect);
        
    UIImage* image = UIGraphicsGetImageFromCurrentImageContext();
    UIGraphicsEndImageContext();
    return image;
}


- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    
    // キーボード表示・非表示時のイベント登録
    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(keyboardWasShown:)
                                                 name:UIKeyboardDidShowNotification object:nil];
    
    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(keyboardWasHidden:)
                                                 name:UIKeyboardDidHideNotification object:nil];
}

- (void)viewWillDisappear:(BOOL)animated {
    // キーボード表示・非表示時のイベント削除
    [[NSNotificationCenter defaultCenter] removeObserver:self];
}

- (void)keyboardWasShown:(NSNotification *)notification {
    NSDictionary *info = [notification userInfo];
    CGSize kbSize = [[info objectForKey:UIKeyboardFrameBeginUserInfoKey] CGRectValue].size;
    
    UIEdgeInsets contentInsets = UIEdgeInsetsMake(0.0, 0.0, kbSize.height, 0.0);
    
    self.sclView.contentInset = contentInsets;
    self.sclView.scrollIndicatorInsets = contentInsets;
    
    CGRect aRect = self.view.frame;
    aRect.size.height -= kbSize.height;
    if (_activeField != nil)
    {
        CGPoint scrollPoint = CGPointMake(0.0, _activeField.frame.origin.y - 30);
        [self.sclView setContentOffset:scrollPoint animated:YES];
    }
}

- (void)keyboardWasHidden:(NSNotification *)notification {
    UIEdgeInsets contentInsets = UIEdgeInsetsZero;
    self.sclView.contentInset = contentInsets;
    self.sclView.scrollIndicatorInsets = contentInsets;
}

- (void)textFieldDidBeginEditing:(UITextField *)textField {
    _activeField = textField;
}

- (void)textFieldDidEndEditing:(UITextField *)textField {
    _activeField = nil;
}

@end
